In vanilla Valheim, structures can be pretty sturdy. Mods can easily turn your fortresses or ships into houses of cards though. This mod aims to remedy this.

Structures in the game will be put into a configurable number of categories. By default, the mod just differs between ships and player build structures. Non-player structures are ignored.

Whether a structure is in a category can be determined by:
- Name of the structure.
- Material of the structure.
- Exclude non-player structures.

For each category one can modify the damage done to the structures in two ways:
- Using global keys, which are used by vanilla Valheim to determine which boss has been defeated.
- Using any item that needs to be in the player inventory with an effect range that can also be configured.
If one of the conditions is satisfied, the damage done to structures will be reduced accordingly.
Example from the default config:
- After defeating Yagluth, all player structures will only take 50% of the usual damage.
- If carrying 'Yagluth thing', the damage of structures within 100m is reduced by a (further) 50% multiplicatively, thus resulting in 25% leftover damage.


Furthermore, auto-repair of structures can be configured in a very similar way. Using boss keys is not possible here. This is mostly meant for automatically repairing hard to reach stuff that might have been hit by an AOE attack.
Example from the default config:
- If carrying 'Yagluth thing', every 2 minutes all player structures within 100m of the player will be repaired by 5%.

Installation:
Simply unpack and put into BepInEx/plugins folder. Obviously required BepInEx

### Changelog
1.0.1 Fixed beehives being indestructable
1.0.2 Fixes config reading for systems with comma as decimal separator. Updated default EVA keys. Minor improvement in console usage.

Example config (slight extended to what the game will auto-generate on launch with this mod.

```﻿﻿
## Settings file was created by plugin Structure Damage Tweaks v1.0.0
## Plugin GUID: StructureDamageTweaks

[AutoRepair]

## Timer in seconds on how often auto repair is applied if the player has
an according item (see in categories). Disabled if value is zero. Low
values not adviced.
# Setting type: UInt32
# Default value: 120
Timer = 120

[Category]

## Number of additional categories for which damage reductions may be
defined. Remark: You can use a category to exclude structures from
another category. Each structure can always be in only one category and
they are tested zero first, ..., default last
# Setting type: UInt32
# Default value: 1
NumberOfCategories = 2

[Category0]

## What is used to determine if a structure in inside this category.
Options: 'structureName', 'material', 'none'. In '[CategoryDefault]'
this is always 'none'.
# Setting type: String
# Default value: structureName
type = structureName

## Names of the structure(s) in this category.
# Setting type: String
# Default value: raft,karve,vikingship,littleboat,cargoship,bigcargoship
StructureName = raft,karve,vikingship,littleboat,cargoship,bigcargoship

## Only used in game with logging enabled. Though I advice naming your categories for clarity
# Setting type: String
# Default value: Ships
name = Ships

## Determines whether this group only applies to structures build by any
player. Be aware, that if this is false, this may include beehives or
other structures that you actually want to destroy.
# Setting type: Boolean
# Default value: true
OnlyPlayerStructures = true

## Global keys that apply modifiers. First applicable key will be used.
Example values:
defeated_eikthyr,defeated_gdking,defeated_bonemass,defeated_dragon,defeated_goblinking,defeated_MourningQueen,KilledJotunn,defeated_damnedone
# Setting type: String
# Default value: defeated_damnedone,KilledJotunn,defeated_MourningQueen,defeated_goblinking
GlobalKeysNames = defeated_damnedone,KilledJotunn,defeated_MourningQueen,defeated_goblinking

## Damage multipliers per name. First applicable multiplier will be used.
This list should have the same length as 'GlobalKeysNames'. Values that
cannot be converted to a float will be ignored. Values below zero would
repair a structure and are not adviced. Below one reduces damage to
structures. Above one will increase damage.
# Setting type: String
# Default value: 0.01,0.2,0.3,0.5
GlobalKeysMultipliers = 0.01,0.2,0.3,0.5

## 'Token name' of items that apply modifiers if in player inventory. See
https://github.com/Valheim-Modding/Wiki/wiki/ObjectDB-Table for vanilla
items. You can use 'structuredamagetweaks inventory' ingame to print a
full list of 'Token names' for what is currently in your inventory.
First applicable item with an actuall effect (see below) in this list
will be used.
# Setting type: String
# Default value: Yagluth thing
ItemInInventoryRequirements = Yagluth thing

## Damage multipliers per item. First applicable multiplier that is
unequal to '1' will be used. This list should have the same length as
'ItemInInventoryRequirements'. Missing or non-float-convertable ones
will be set to '1', i.e. no effect. Values below zero would repair a
structure and are not adviced. Below one reduces damage to structures.
Above one will increase damage.
# Setting type: String
# Default value: 0.5
ItemInInventoryMultipliers = 0.5

## Amount of auto-repair per item. All structures in range will be
repaired by this percentage every '[AutoRepair]Timer' seconds. First
applicable non-zero value will be used. This list should have the same
length as 'ItemInInventoryRequirements', missing entries will be set to
zero, i.e. no effect.
# Setting type: String
# Default value: 5
ItemInInventoryAutoRepairPercentage = 5

## Range per item.Checked per structure.This is a restriction as to when
an item is 'applicable', see above.This list should have the same length
as 'ItemInInventoryRequirements', missing entries will be set to the
maximum given range, or '10' should the whole list be empty.Different
items with different ranges can work together if ordered correctly: Put
strong short range items first.
# Setting type: String
# Default value: 100
ItemInInventoryRange = 100

[Category1]

## Names of the material(s) in this category. Possibly values: Wood, Stone, Iron, HardWood
# Setting type: String
# Default value: Iron
MaterialTypes = Iron

## Only used in game with logging enabled. Though I advice naming your categories for clarity
# Setting type: String
# Default value: IronExample
name = IronExample

## Determines whether this group only applies to structures build by any
player. Be aware, that if this is false, this may include beehives or
other structures that you actually want to destroy.
# Setting type: Boolean
# Default value: true
OnlyPlayerStructures = true

## Global keys that apply modifiers. First applicable key will be used.
Example values:
defeated_eikthyr,defeated_gdking,defeated_bonemass,defeated_dragon,defeated_goblinking,defeated_MourningQueen,KilledJotunn,defeated_damnedone
# Setting type: String
# Default value: defeated_damnedone,KilledJotunn,defeated_MourningQueen,defeated_goblinking
GlobalKeysNames = defeated_damnedone,KilledJotunn,defeated_MourningQueen,defeated_goblinking

## Damage multipliers per name. First applicable multiplier will be used.
This list should have the same length as 'GlobalKeysNames'. Values that
cannot be converted to a float will be ignored. Values below zero would
repair a structure and are not adviced. Below one reduces damage to
structures. Above one will increase damage.
# Setting type: String
# Default value: 0.01,0.2,0.3,0.5
GlobalKeysMultipliers = 0.01,0.2,0.3,0.5

## 'Token name' of items that apply modifiers if in player inventory. See
https://github.com/Valheim-Modding/Wiki/wiki/ObjectDB-Table for vanilla
items. You can use 'structuredamagetweaks inventory' ingame to print a
full list of 'Token names' for what is currently in your inventory.
First applicable item with an actuall effect (see below) in this list
will be used.
# Setting type: String
# Default value: Yagluth thing
ItemInInventoryRequirements = Yagluth thing

## Damage multipliers per item. First applicable multiplier that is
unequal to '1' will be used. This list should have the same length as
'ItemInInventoryRequirements'. Missing or non-float-convertable ones
will be set to '1', i.e. no effect. Values below zero would repair a
structure and are not adviced. Below one reduces damage to structures.
Above one will increase damage.
# Setting type: String
# Default value: 0.5
ItemInInventoryMultipliers = 0.5

## Amount of auto-repair per item. All structures in range will be
repaired by this percentage every '[AutoRepair]Timer' seconds. First
applicable non-zero value will be used. This list should have the same
length as 'ItemInInventoryRequirements', missing entries will be set to
zero, i.e. no effect.
# Setting type: String
# Default value: 5
ItemInInventoryAutoRepairPercentage = 5

## Range per item.Checked per structure.This is a restriction as to when
an item is 'applicable', see above.This list should have the same length
as 'ItemInInventoryRequirements', missing entries will be set to the
maximum given range, or '10' should the whole list be empty.Different
items with different ranges can work together if ordered correctly: Put
strong short range items first.
# Setting type: String
# Default value: 100
ItemInInventoryRange = 100

[CategoryDefault]

## Only used in game with logging enabled. Though I advice naming your categories for clarity
# Setting type: String
# Default value: Default
name = Default

## Determines whether this group only applies to structures build by any
player. Be aware, that if this is false, this may include beehives or
other structures that you actually want to destroy.
# Setting type: Boolean
# Default value: true
OnlyPlayerStructures = true

## Global keys that apply modifiers. First applicable key will be used.
Example values:
defeated_eikthyr,defeated_gdking,defeated_bonemass,defeated_dragon,defeated_goblinking,defeated_MourningQueen,KilledJotunn,defeated_damnedone
# Setting type: String
# Default value: defeated_damnedone,KilledJotunn,defeated_MourningQueen,defeated_goblinking
GlobalKeysNames = defeated_damnedone,KilledJotunn,defeated_MourningQueen,defeated_goblinking

## Damage multipliers per name. First applicable multiplier will be used.
This list should have the same length as 'GlobalKeysNames'. Values that
cannot be converted to a float will be ignored. Values below zero would
repair a structure and are not adviced. Below one reduces damage to
structures. Above one will increase damage.
# Setting type: String
# Default value: 0.1,0.2,0.3,0.5
GlobalKeysMultipliers = 0.1,0.2,0.3,0.5

## 'Token name' of items that apply modifiers if in player inventory. See
https://github.com/Valheim-Modding/Wiki/wiki/ObjectDB-Table for vanilla
items. You can use 'structuredamagetweaks inventory' ingame to print a
full list of 'Token names' for what is currently in your inventory.
First applicable item with an actuall effect (see below) in this list
will be used.
# Setting type: String
# Default value: Yagluth thing
ItemInInventoryRequirements = Yagluth thing

## Damage multipliers per item. First applicable multiplier that is
unequal to '1' will be used. This list should have the same length as
'ItemInInventoryRequirements'. Missing or non-float-convertable ones
will be set to '1', i.e. no effect. Values below zero would repair a
structure and are not adviced. Below one reduces damage to structures.
Above one will increase damage.
# Setting type: String
# Default value: 0.5
ItemInInventoryMultipliers = 0.5

## Amount of auto-repair per item. All structures in range will be
repaired by this percentage every '[AutoRepair]Timer' seconds. First
applicable non-zero value will be used. This list should have the same
length as 'ItemInInventoryRequirements', missing entries will be set to
zero, i.e. no effect.
# Setting type: String
# Default value: 5
ItemInInventoryAutoRepairPercentage = 5

## Range per item.Checked per structure.This is a restriction as to when
an item is 'applicable', see above.This list should have the same length
as 'ItemInInventoryRequirements', missing entries will be set to the
maximum given range, or '10' should the whole list be empty.Different
items with different ranges can work together if ordered correctly: Put
strong short range items first.
# Setting type: String
# Default value: 100
ItemInInventoryRange = 100

[Logging]

## Enable logging. Please be aware, that enabling this together with auto
repair will slow your game each time auto repair is performed if you are
in a region with many instances that are in need of repairs.
# Setting type: Boolean
# Default value: false
Logging Enabled = false
```
